//AIM:Design High pass Butterworth filter using Bilinear Transformation.
//Software version Scilab 5.5.2
//OS windows 10
clc;
clear;
s=poly(0,"s")
T=1;//Assume T=1 second
Ap=0.8;//Attenuation in pass band
As=0.2;//Attenuation in stop band
wp=0.2*(%pi)
ws=0.6*(%pi)
ohmp=2/T*(tan(wp/2))
ohms=2/T*(tan(ws/2))
//ORDER CALCULATION(N);
a=(1/As^2-1)
b=(1/Ap^2-1)
c=log(a/b)
N=(1/2)*(c/(log(ohms/ohmp)))
Nr=int (N)
x=N-int(N)
if(x>0)
 Nr=Nr+1    
ohmc=(ohmp/(1/Ap^2-1)^(1/(2*Nr)))
//calculation of poles
i=0:1:Nr-1;
pi_plus=ohmc*exp(%i*(Nr+2*i+1)*(%pi)/(2*Nr))
pi_minus=-ohmc*exp(%i*(2+2.*i+1)*(%pi)/(2*Nr))
disp(wp,'ωp=')
disp(ws,'ωs=')
disp(ohmp,'Ωp=')
disp(ohms,'Ωs=')
disp(N','Order (N)=')
disp(Nr,'Integer value of the order:(Nr)=')
disp(ohmc,'Ωc=')
disp(pi_plus,'Poles=')
disp(pi_minus,'Poles=')
h=ohmc/(s-(-0.53-0.53*%i))
h1=ohmc/(s-(-0.53+0.53*%i))
h2=h*h1;
disp(h,h1,'The analog transfer function will be the multiplication of the following two terms:');
disp(h2,'The analog transfer function H(s)=')
Z=poly(0,"Z")
s=(ohmc*ohmp)/((2/T)*((Z-1)/(Z+1)));
h3=0.56/(s^2+1.06*s+0.56);
disp(h3,"Transfer function of digital filter H(Z)=")

